<?php
@session_start();

$config = array_filter((array)@unserialize(file_get_contents(dirname(__FILE__)."/../cfg/leech.dat")));
if(!@$config['debug'])
{
	$errlevel = error_reporting(0);
}

list($type, $url) = explode(":",urldecode($_SERVER['QUERY_STRING']), 2);

$url = $config['encrypt'] ? base64_decode($url) : $url;

switch($type)
{
	case "a":
		if($config['teaser'])
		{
			$root = "http://".$_SERVER['HTTP_HOST']."/";
			$host = $_SERVER['HTTP_HOST'];

			$refresh = '';
			$timer = '';
			
			if($config['refresh'])
			{
				$refresh = '<meta http-equiv="refresh" content="'.(int)$config['refresh_delay'];
				$refresh .= '; url='.htmlspecialchars($url).'" />';

				$timer = '<span id="timer">'.(int)$config['refresh_delay'].'</span>';
				$timer .= '<script type="text/javascript">
						window.onload = function () {
							var timer = document.getElementById("timer");
							var delay = '.(int)$config['refresh_delay'].';
							var location = "'.addslashes($url).'";
							var interval = setInterval(function () {
								if(delay)
								{
									delay--;
								}

								timer.innerHTML = delay;
								if(delay <= 0)
								{
									clearInterval(interval);
									window.location.href=location;
								}
							}, 1000);
						};
					</script>';
			}

			if($config['teaser_use_php'])
			{
				require_once dirname(__FILE__).'/../cfg/leech_teaser.php';
			}
			else
			{
				$html = file_get_contents(dirname(__FILE__).'/../cfg/leech_teaser.html');

				$replace = array(
						"{url}" => $url,
						"{host}" => $host,
						"{root}" => $root,
				);
				$replace = array_map("htmlspecialchars",$replace);
				$replace["{refresh}"] = $refresh;
				$replace["{timer}"] = $timer;

				echo str_replace(array_keys($replace), $replace, $html);
			}
		}
		else
		{
			header("HTTP/1.1 301 Moved Permanently");
			header("Location: $url");
		}

		break;

	case "i":
		header("HTTP/1.1 301 Moved Permanently");
		header("Location: $url");
		break;

	default:
		header("HTTP/1.1 301 Moved Permanently");
		header("Location: /");
		break;
}
die();